/*
    module: engine.h
  synopsis: header file for the Genesys source code engine

     usage:

    author: Marc Wolfgram
      date: 05Jul89
   revised: 10Aug89  updated, register logic defined.  
            24Sep89  revised err defines.
            02Oct89  fixed improper rule declaration in lData.
            11Jan90  moved comment to end and added CTRL command.
         B3 28Mar90  added PTEXT and INDEX commands.

            Copyright (c) 1989, 1990
            Simple Software Systems International, Inc.

            ALL RIGHTS RESERVED
*/

#ifndef __ENGINE__
#define __ENGINE__

#define T_AND   0
#define T_BIT   1
#define T_BYTE  2
#define T_CONT  3
#define T_CSTR  4
#define T_CTRL  5
#define T_DEC   6
#define T_DONE  7
#define T_ELSE  8
#define T_END   9
#define T_EQ    10
#define T_GE    11
#define T_GSOS  12
#define T_GT    13
#define T_IF    14
#define T_INC   15
#define T_LE    16
#define T_LOAD  17
#define T_LONG  18
#define T_LOOP  19
#define T_LT    20
#define T_NAME  21
#define T_NE    22
#define T_NOR   23
#define T_NSTR  24
#define T_OR    25
#define T_PSTR  26
#define T_READ  27
#define T_TYPE  28
#define T_WORD  29
#define T_WRITE 30
#define T_XOR   31
#define COMMENT 32
#define M_MUL   33
#define M_DIV   34
#define M_MOD   35
#define T_SL    36
#define T_SR    37
#define T_PTEXT 38
#define T_INDEX 39
#define T_TITLE 40

#define CMDMAX 41

#define RNAME_TYPE 0x8014

#define F_BADBITTOK 256
#define F_BADCMDTOK 257
#define F_BADRESTOK 258
#define F_BADCTLTOK 259
#define F_DIVBYZERO 260
#define F_BADIFTTOK 261

struct  EngineRec {
 GSString255Ptr sName;
    int         resID,
                memID;
    long        pLang;  /* auxtype */
    word        rType;
    int         flag;
};

/* lData is the repository for language data */
struct  lData {
    word        rType;
    char        *rule;
    struct lData *next;
};

#endif
